<?php
namespace VM\AdminBundle\Command;

use Doctrine\Bundle\DoctrineBundle\Registry;
use Doctrine\ORM\EntityManager;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use VM\ApiBundle\Entity\SummaryCompanyRound;

class UpdateChangeProductionCostCommand extends ContainerAwareCommand
{
    private $Container;

    protected function configure()
    {
        $this
            ->setName('game:changeProductionCost:update')
            ->setDescription('Update +/- changeProductionCost for accountChanges')
            ->addOption('force', null, InputOption::VALUE_OPTIONAL, 'Force save in DB', false)
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $EntityManager = $this->getDoctrine();
        $ApiGetter = $this->getContainer()->get('vm_admin.api.getter');
        $ApiCreator = $this->getContainer()->get('vm_admin.api.creator');
        $count = 0;

        $forceSave = ((integer)$input->getOption('force', false) == 1);

        $Companies = $EntityManager->getRepository('VMApiBundle:Company')->findAll();

        foreach($Companies as $Company)
        {
            $countValue = 0;
            if(!$Company->getSummaryCompanyRound()->isEmpty())
            {
                $output->writeln('Company (id=<info>'.$Company->getId().'</info>) - <info>' . $Company->getName() . '</info>');
                $CurrentAccount = $ApiGetter->getCompanyCurrentAccount($Company->getId());
                /** @var $SummaryCompanyRound SummaryCompanyRound */
                foreach($Company->getSummaryCompanyRound() as $SummaryCompanyRound)
                {
                    $data = json_decode($SummaryCompanyRound->getData(),true);
                    $bazowyKosztProdukcji = floatval($data['finansowanieProdukcji']['bazowyKosztProdukcji']);
                    $kosztMateriałow = floatval($data['finansowanieProdukcji']['kosztyZmienne']['materialowe']['cenaJednostki']);
                    $mozliwosciProdukcyjne = intval($data['finansowanieProdukcji']['mozliwosciProdukcyjne']);

                    if($bazowyKosztProdukcji != $kosztMateriałow && $mozliwosciProdukcyjne > 0)
                    {
                        $changeCost = $bazowyKosztProdukcji-$kosztMateriałow;
                        $CurrentAccountValue=$mozliwosciProdukcyjne*$changeCost;

                        $output->writeln("\t Runda - <info>".$SummaryCompanyRound->getRound()->getName()."</info>");
                        $output->writeln("\t\t bazowyKosztProdukcj - kosztMateriałow = changeCost");
                        $output->writeln("\t\t ".$bazowyKosztProdukcji.' - '.$kosztMateriałow.' = '.$changeCost);
                        $output->writeln("\t\t mozliwosciProdukcyjne      =".$mozliwosciProdukcyjne);
                        $output->writeln("\t\t ChangeCurrentAccountValue  =".$CurrentAccountValue);

                        $CurrentAccount->setValue($CurrentAccount->getValue()+$CurrentAccountValue);
                        $AccountChange = $ApiCreator->createAccountChange($SummaryCompanyRound->getRound(), $Company, $CurrentAccountValue, 'Zmiana kosztów wyprodukowania jednej sztuki towaru dla '.$SummaryCompanyRound->getRound()->getName());
                        $EntityManager->persist($AccountChange);
                        $count++;
                        $countValue += $CurrentAccountValue;
                    }
                }
                if($countValue != 0)
                {
                    $output->writeln("\t CurrentAccountValue        =".$CurrentAccount->getValue());
                    $output->writeln("\t ChangeCurrentAccountValue  =".$countValue);
                }
            }

        }
        $output->writeln("Update <info>".$count."</info> tur");

        if($forceSave)
        {
            $output->writeln("FLUSH");
            $EntityManager->flush();
        }
    }


    /**
     * @return EntityManager
     */
    protected function getDoctrine()
    {
        return $this->getContainer()->get('doctrine.orm.default_entity_manager');
    }
}